/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.kawakubo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 *
 * @author tomoharu
 */
public class ImoshochuCatalogDAOImpl implements ImoshochuCatalogDAO {
    
    private static final String sql = "select * from meigara";

    public ArrayList<ImoshochuCatalogItem> getImoshochuCatalogList() {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        ArrayList<ImoshochuCatalogItem> imoCatalog = new ArrayList<ImoshochuCatalogItem>();
        try {
            Context c = new InitialContext();
            DataSource ds = (DataSource)c.lookup("java:comp/env/jdbc/imoshop");
            conn = ds.getConnection();
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            ImoshochuCatalogItem imoItem = null;
            while(rs.next()) {
                imoItem = new ImoshochuCatalogItem();
                imoItem.setId(rs.getInt("id"));
                imoItem.setName(rs.getString("name"));
                imoItem.setNameKana(rs.getString("nameKana"));
                imoItem.setDosu(rs.getInt("dosu"));
                imoItem.setKoji(rs.getString("koji"));
                imoItem.setSweetPotatoName(rs.getString("sweetPotatoName"));
                imoItem.setManufacturer(rs.getString("manufacturer"));
                imoItem.setVolume(rs.getFloat("volume"));
                imoItem.setPrice(rs.getInt("price"));
                imoCatalog.add(imoItem);
            }
        } catch(SQLException se) {
            se.printStackTrace();
        } catch(Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            } catch(SQLException se) {
                se.printStackTrace();
            }
        }
        return imoCatalog;
    }
}
